//..............................................................................
//
//  This file is part of the Jancy toolkit.
//
//  Jancy is distributed under the MIT license.
//  For details see accompanying license.txt file,
//  the public copy of which is also available at:
//  http://tibbo.com/downloads/archive/jancy/license.txt
//
//..............................................................................

#include "pch.h"
#include "jnc_ct_ImportType.h"
#include "jnc_ct_Decl.h"
#include "jnc_ct_Module.h"

namespace jnc {
namespace ct {

//..............................................................................

void
ImportType::applyFixups ()
{
	ASSERT (m_actualType);

	size_t count = m_fixupArray.getCount ();
	for (size_t i = 0; i < count; i++)
		*m_fixupArray [i] = m_actualType;
}

//..............................................................................

NamedImportType::NamedImportType ()
{
	m_typeKind = TypeKind_NamedImport;
	m_anchorNamespace = NULL;
}

ImportPtrType*
NamedImportType::getImportPtrType (
	uint_t typeModifiers,
	uint_t flags
	)
{
	return m_module->m_typeMgr.getImportPtrType (this, typeModifiers, flags);
}

sl::String
NamedImportType::createSignature (
	const QualifiedName& name,
	Namespace* anchorNamespace,
	const QualifiedName& orphanName
	)
{
	sl::String signature = sl::formatString ("ZN%s", anchorNamespace->createQualifiedName (name).sz ());

	if (!orphanName.isEmpty ())
	{
		signature += '-';
		signature += orphanName.getFullName ();
	}

	return signature;
}

NamedImportType*
NamedImportType::setAnchorName (const QualifiedName& name)
{
	if (!m_fixupArray.isEmpty ())
		return m_module->m_typeMgr.getNamedImportType (m_name, m_anchorNamespace, name);

	ASSERT (m_anchorName.isEmpty ());
	m_anchorName = name;
	m_typeStringTuple = NULL;

	m_qualifiedName = m_anchorNamespace->createQualifiedName (name);
	m_qualifiedName += '.';
	m_qualifiedName += m_name.getFullName ();

	sl::String signature = createSignature (m_name, m_anchorNamespace, m_anchorName);
	m_module->m_typeMgr.updateTypeSignature (this, signature);
	return this;
}

//..............................................................................

ImportPtrType::ImportPtrType ()
{
	m_typeKind = TypeKind_ImportPtr;
	m_targetType = NULL;
	m_typeModifiers = 0;
}

void
ImportPtrType::prepareTypeString ()
{
	ASSERT (m_targetType);
	TypeStringTuple* tuple = getTypeStringTuple ();

	if (m_actualType)
	{
		tuple->m_typeStringPrefix = m_actualType->getTypeStringPrefix ();
		tuple->m_typeStringSuffix = m_actualType->getTypeStringSuffix ();
		return;
	}

	tuple->m_typeStringPrefix = "import ";

	if (m_typeModifiers)
	{
		tuple->m_typeStringPrefix += getTypeModifierString (m_typeModifiers);
		tuple->m_typeStringPrefix += ' ';
	}

	tuple->m_typeStringPrefix += m_targetType->getQualifiedName ();
	tuple->m_typeStringPrefix += '*';
}

//..............................................................................

ImportIntModType::ImportIntModType ()
{
	m_typeKind = TypeKind_ImportPtr;
	m_importType = NULL;
	m_typeModifiers = 0;
}

void
ImportIntModType::prepareTypeString ()
{
	TypeStringTuple* tuple = getTypeStringTuple ();

	if (m_actualType)
	{
		tuple->m_typeStringPrefix = m_actualType->getTypeStringPrefix ();
		return;
	}

	tuple->m_typeStringPrefix = "import ";

	if (m_typeModifiers)
	{
		tuple->m_typeStringPrefix += getTypeModifierString (m_typeModifiers);
		tuple->m_typeStringPrefix += ' ';
	}

	tuple->m_typeStringPrefix += m_importType->getQualifiedName ();
}

//..............................................................................

} // namespace ct
} // namespace jnc
